using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Security.AntiXss;
using System.Web.UI;

using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.EFR.UTIL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class FragLabInterpretation : InterpretationBasePage
    {
        private const string ReferralKey = "FragLabInterpretation_Referrer";

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretationLetters.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        private readonly LabResultsInterpretationManager labResultsInterpretationManager;

        private WKF_CASE_ACTIVITY activity;
        private WKF_CASE wCase;
        private STD_WKFACTIVITYSTS activityStatus;
        private PatientDetails patientDetails;

        public FragLabInterpretation()
        {
            labResultsInterpretationManager = new LabResultsInterpretationManager();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            NavigationSources = navigationSources;

            LabResultInterpretation1.OnCancelClick += LabResultInterpretation1_OnCancelClick;
            LabResultInterpretation1.OnSaveClick += LabResultInterpretation1_OnSaveClick;
            LabResultInterpretation1.OnInterpretComplete += LabResultInterpretation1_OnInterpretComplete;
            LabResultInterpretation1.OnPrintPatientLetter += LabResultInterpretation1_OnPrintPatientLetter;
            LabResultInterpretation1.OnPrintProviderLetter += LabResultInterpretation1_OnPrintProviderLetter;
            LabResultInterpretation1.OnAddPrintQueue += LabResultInterpretation1_OnAddPrintQueue;

            if (!IsPostBack)
            {
                int CaseId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["CaseId"], false));
                BindData(CaseId);

                SetOriginalReferringPage(ReferralKey);
                SetReferringPage();
            }
        }

        void LabResultInterpretation1_OnPrintProviderLetter(object sender, EventArgs e)
        {
            Deserialize();

            if (GetInterpretationActivity(wCase).STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();

            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult(wCase).WKF_CASE_ACTIVITY_ID, GetInterpretationActivity(wCase).WKF_CASE_ACTIVITY_ID, "1", wCase.WKF_CASE_ID));
        }

        void LabResultInterpretation1_OnPrintPatientLetter(object sender, EventArgs e)
        {
            Deserialize();

            if (GetInterpretationActivity(wCase).STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();

            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult(wCase).WKF_CASE_ACTIVITY_ID, GetInterpretationActivity(wCase).WKF_CASE_ACTIVITY_ID, "0", wCase.WKF_CASE_ID));
        }

        void LabResultInterpretation1_OnAddPrintQueue(object sender, EventArgs e)
        {
            Deserialize();

            var activity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();

            var letter = INTERPRETATION_LETTERManager.GetItemByWkfCaseActivityId(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);

            if (activity.STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();
            if (activity != null && letter != null)
                labResultsInterpretationManager.UpdateInterpretationLetterPrintQueue(CurrentUser, CurrentRegistryId, letter, true);
        }

        private void BindData(int caseId)
        {
            wCase = labResultsInterpretationManager.GetLabInterpretationDetails(CurrentUser, CurrentRegistryId, caseId);
            if (wCase == null) return;

            activity = GetLabResult(wCase);

            patientDetails = PatientDetailsManager.GetItem(CurrentUser, CurrentRegistryId, wCase.PATIENT_ID);
            ViewState["patientDetails"] = patientDetails.Serialize();
            ViewState["wCase"] = wCase.Serialize();

            WKF_CASE_ACTIVITY order = GetLabOrder(wCase);

            FragLabResult1.BindData(activity, order, true);

            // Bind provider, patient details
            // Populate patient updated address
            LabResultInterpretation1.PopulatePatientProviderDetails(CurrentUser, CurrentRegistryId, wCase, "Fragment");

            var intActivity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();

            activityStatus = intActivity.STD_WKFACTIVITYSTS;
            ViewState["OrderType"] = activityStatus.ID;

            ReplacePageTitle("My Tasks > Interpretation & Follow Up > " + activityStatus.NAME + " > Workflow ID " + wCase.WKF_CASE_ID.ToString());
        }

        void LabResultInterpretation1_OnInterpretComplete(object sender, EventArgs e)
        {
            Deserialize();

            var activity = GetInterpretationActivity(wCase);

            activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted);

            OpenCloseReferralAndWorkflowCase(() => "Interpret", wCase, patientDetails.PATIENT_ICN);

            LabResultInterpretation1.UpdateInterpretationDetails(CurrentUser, CurrentRegistryId, wCase);

            CreateNewContact(patientDetails, wCase.REFERRAL_ID.Value);

            labResultsInterpretationManager.UpdateInterpretationActivity(CurrentUser, CurrentRegistryId, activity);

            BindData(wCase.WKF_CASE_ID);

            var letter = INTERPRETATION_LETTERManager.GetItemByWkfCaseActivityId(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);
            if (activity != null && letter != null)
                labResultsInterpretationManager.UpdateInterpretationLetterPrintQueue(CurrentUser, CurrentRegistryId, letter, false);
        }

        void LabResultInterpretation1_OnCancelClick(object sender, EventArgs e)
        {
            Redirect();
        }

        void LabResultInterpretation1_OnSaveClick(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                Deserialize();
                OpenCloseReferralAndWorkflowCase(() => "Save", wCase, patientDetails.PATIENT_ICN);
                SaveData();
                BindData(wCase.WKF_CASE_ID);
            }
        }

        private void SaveData()
        {
            Deserialize();

            var activity = GetInterpretationActivity(wCase);

            if (activity.STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted))
                activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);

            // Check if the pre-populated patient address has been changed.
            LabResultInterpretation1.UpdateInterpretationDetails(CurrentUser, CurrentRegistryId, wCase);

            // Call update from the interpretation manager
            labResultsInterpretationManager.UpdateInterpretationActivity(CurrentUser, CurrentRegistryId, activity);

            SetSaveSuccessMessage();
        }

        private void Deserialize()
        {
            wCase = SerializerUtility.Deserialize<WKF_CASE>((string)ViewState["wCase"]);
            patientDetails = SerializerUtility.Deserialize<PatientDetails>((string)ViewState["patientDetails"]);
            activity = GetLabResult(wCase);
        }

        private void Redirect()
        {
            RedirectToOriginalReferringPage(ReferralKey);
        }
    }
}